/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.contracts.service;

import itx.erp.base.model.Activity;
import itx.erp.base.model.DbFile;
import itx.erp.base.model.User;
import itx.erp.base.model.UserPermission;
import itx.erp.base.service.ErpServiceBase;
import itx.erp.base.service.FileService;
import itx.erp.base.service.MetaService;
import itx.erp.base.service.UserService;
import itx.erp.contracts.model.Contract;
import itx.erp.contracts.model.ContractRelated;
import itx.erp.contracts.model.ContractTask;
import itx.erp.contracts.model.ContractTaskEvent;
import itx.erp.contracts.model.ContractTaskUserMeta;
import itx.erp.contracts.model.ContractType;
import itx.erp.customer.model.Customer;
import itx.erp.customer.service.CustomerService;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jtbcore.db.common.QueryBuilder;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.InvalidStateException;
import jtbcore.exception.JTBException;
import jtbcore.model.BaseStringMap;
import jtbcore.util.DateUtil;
import jtbcore.util.MapUtil;
import jtbcore.util.NumberUtil;
import jtbcore.util.StringUtil;

public class ContractService
extends ErpServiceBase {
    final String[] contractLogFields = new String[]{"status", "name", "amountDescription", "contractTypeName", "customerId", "startDate", "endDate", "timeNotice", "timeNoticeUnit", "renewPeriod", "renewUnit", "autoRenew", "note", "permissionDescriptions"};
    final String[] contractTaskLogFields = new String[]{"description", "status", "noticeMoment", "taskDate", "timeNotice", "timeNoticeUnit", "note"};
    final String[] contractTypeLogFields = new String[]{"name"};
    protected UserService userService;
    protected CustomerService customerService;
    protected FileService fileService;
    protected MetaService metaService;

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    public FileService getFileService() {
        return this.fileService;
    }

    public void setFileService(FileService fileService) {
        this.fileService = fileService;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public List<ContractType> readAllContractTypes() throws SQLException, JTBException {
        return this.queryToList(ContractType.class, "select * from contract__contract_type order by sort, contract_type_id", new Object[0]);
    }

    public ContractType readContractType(Integer id) throws SQLException, JTBException {
        Object o = this.queryToObject(ContractType.class, "select * from contract__contract_type where contract_type_id = ?", id);
        return (ContractType)o;
    }

    public void deleteContractType(Integer id, Integer loggedIn_userId) throws SQLException, JTBException, IOException {
        ContractType ct = this.readContractType(id);
        this.connection.query("delete from contract__contract_type where contract_type_id = ?", id);
        Activity a = new Activity();
        a.setRefObject(ContractType.class.getName());
        a.setRefId(ct.getContractTypeId());
        if (loggedIn_userId != null) {
            a.setUserId(loggedIn_userId);
        }
        a.setCode("contract-type-deleted");
        a.setShortDescription("Contract type deleted: " + ct.getName());
        a.logDelete(ct, this.contractTypeLogFields);
        this.saveActivity(a);
    }

    public Integer saveContractType(ContractType ct, Integer loggedIn_userId) throws IOException, SQLException, JTBException {
        ContractType old_ct = null;
        if (ct.getContractTypeId() != null) {
            old_ct = this.readContractType(ct.getContractTypeId());
        }
        Integer id = this.connection.save("contract__contract_type", "contract_type_id", ct);
        Activity a = new Activity();
        a.setRefObject(ContractType.class.getName());
        a.setRefId(ct.getContractTypeId());
        if (loggedIn_userId != null) {
            a.setUserId(loggedIn_userId);
        }
        if (old_ct != null) {
            a.setCode("contract-type-updated");
            a.setShortDescription("Contract type changed: " + old_ct.getName() + " => " + ct.getName());
            a.logChange(old_ct, ct, this.contractTypeLogFields);
        } else {
            a.setCode("contract-type-new");
            a.setShortDescription("Create contract type: " + ct.getName());
            a.logNew(ct, this.contractTypeLogFields);
        }
        this.saveActivity(a);
        return id;
    }

    public void updateSortContractType(String[] ids) throws SQLException {
        int x = 0;
        while (x < ids.length) {
            Integer id = NumberUtil.tryParseInt(ids[x]);
            if (id != null) {
                this.connection.query("update contract__contract_type set sort = ? where contract_type_id = ?", x, id);
            }
            ++x;
        }
    }

    public QueryResult<Contract> searchContract(Map<String, Object> opts) throws SQLException {
        Integer dbFileId;
        String contractFilter;
        Object q;
        QueryBuilder qb = new QueryBuilder(this.connection);
        qb.setTable("contract__contract");
        qb.addSelectField("contract__contract", "contract_id");
        qb.addSelectField("contract__contract", "contract_type_id");
        qb.addSelectField("contract__contract", "customer_id");
        qb.addSelectField("contract__contract", "name");
        qb.addSelectField("contract__contract", "amount_description");
        qb.addSelectField("contract__contract", "start_date");
        qb.addSelectField("contract__contract", "end_date");
        qb.addSelectField("contract__contract", "auto_renew");
        qb.addSelectField("contract__contract", "time_notice");
        qb.addSelectField("contract__contract", "time_notice_unit");
        qb.addSelectField("contract__contract", "renew_unit");
        qb.addSelectField("contract__contract", "renew_period");
        qb.addSelectField("contract__contract", "status");
        qb.addSelectField("contract__contract", "edited");
        qb.addSelectField("contract__contract", "created");
        qb.addSelectField("cust", "customer_name");
        qb.addSelectField("ct", "name", "contract_type_name");
        qb.addLeftJoin("contract__contract_type", "contract__contract.contract_type_id = ct.contract_type_id", "ct");
        qb.addLeftJoin("customer__customer", "contract__contract.customer_id = cust.customer_id", "cust");
        if (MapUtil.hasProperty(opts, "excludeContractId")) {
            Integer excludeContractId = (Integer)opts.get("excludeContractId");
            qb.addWhere("contract__contract.contract_id <> ?", excludeContractId);
        }
        if (MapUtil.hasProperty(opts, "relatedContractId")) {
            Integer relatedContractId = (Integer)opts.get("relatedContractId");
            qb.addJoin("contract__contract_related", "contract__contract.contract_id = cr.ref_contract_id", "cr");
            qb.addWhere("cr.contract_id = ?", relatedContractId);
            qb.setRawOrderBy("cr.sort");
        }
        ArrayList<String> statuses = new ArrayList<String>();
        if (MapUtil.boolValue(opts, "st_open")) {
            statuses.add("open");
        }
        if (MapUtil.boolValue(opts, "st_negotiation")) {
            statuses.add("negotiation");
        }
        if (MapUtil.boolValue(opts, "st_reviewal")) {
            statuses.add("reviewal");
        }
        if (MapUtil.boolValue(opts, "st_accepted")) {
            statuses.add("accepted");
        }
        if (MapUtil.boolValue(opts, "st_active")) {
            statuses.add("active");
        }
        if (MapUtil.boolValue(opts, "st_expiring")) {
            statuses.add("expiring");
        }
        if (MapUtil.boolValue(opts, "st_terminated")) {
            statuses.add("terminated");
        }
        if (statuses.size() > 0) {
            q = "contract__contract.status IN (";
            int x = 0;
            while (x < statuses.size()) {
                if (x > 0) {
                    q = (String)q + ", ";
                }
                q = (String)q + "? ";
                ++x;
            }
            q = (String)q + ")";
            qb.addWhere((String)q, statuses.toArray());
        }
        if (MapUtil.hasProperty(opts, "q")) {
            q = opts.get("q").toString();
            Integer customerId = null;
            if (((String)q).startsWith("customer-")) {
                customerId = NumberUtil.tryParseInt(((String)q).replace("customer-", ""));
            }
            if (customerId != null) {
                qb.addWhere("contract__contract.customer_id = ?", customerId);
            } else {
                q = "%" + (String)q + "%";
                qb.addWhere("contract__contract.name like ? or cust.customer_name like ?", q, q);
            }
        }
        if (MapUtil.hasProperty(opts, "allowedUserId") && opts.get("allowedUserId") instanceof Integer && (contractFilter = this.filterWhereUser((Integer)opts.get("allowedUserId"))) != null) {
            qb.addWhere("contract__contract.contract_id IN " + contractFilter, new Object[0]);
        }
        if (MapUtil.hasProperty(opts, "customerId")) {
            Integer customerId = null;
            if (opts.get("customerId") instanceof String) {
                customerId = NumberUtil.tryParseInt((String)opts.get("customerId"));
            } else if (opts.get("customerId") instanceof Integer) {
                customerId = (Integer)opts.get("customerId");
            }
            if (customerId != null) {
                qb.addWhere("contract__contract.customer_id = " + String.valueOf(customerId), new Object[0]);
            }
        }
        if (MapUtil.hasProperty(opts, "dbFileId") && (dbFileId = NumberUtil.tryParseInt(opts.get("dbFileId").toString())) != null) {
            qb.addWhere("contract__contract.contract_id IN (select contract_id from contract__contract_file where db_file_id = " + String.valueOf(dbFileId) + ") ", new Object[0]);
        }
        if (opts.containsKey("orderby")) {
            qb.setRawOrderBy((String)opts.get("orderby"));
        } else {
            qb.setRawOrderBy("lower(contract__contract.name)");
        }
        if (MapUtil.hasProperty(opts, "status")) {
            qb.addWhere("contract__contract.status = ?", opts.get("status"));
        }
        ResultSet rs = qb.queryResultSet();
        QueryResult<Contract> qr = new QueryResult<Contract>();
        if (MapUtil.hasProperty(opts, "start")) {
            qr.setStart((Integer)opts.get("start"));
        }
        if (MapUtil.hasProperty(opts, "pageSize")) {
            qr.setPageSize((Integer)opts.get("pageSize"));
        }
        qr.fill(Contract.class, rs);
        return qr;
    }

    public String filterWhereUser(Integer userId) throws SQLException {
        if (this.userService.isAdmin(userId)) {
            return null;
        }
        String sql = "(select up.ref_id from base__user_permission up left join base__user_group_link ugl on (up.group_id = ugl.user_group_id) where (up.user_id = " + String.valueOf(userId) + " or ugl.user_id = " + String.valueOf(userId) + ") and up.ref_object='contract') ";
        return sql;
    }

    protected void setNextValues(List<ContractTask> contractTasks) throws SQLException {
        for (ContractTask ct : contractTasks) {
            this.setNextValue(ct);
        }
    }

    protected void setNextValue(ContractTask contractTask) throws SQLException {
        if (!contractTask.isActive()) {
            contractTask.setNextStatus("inactive");
        } else {
            String sql = "select * from contract__contract_task_event where contract_task_id = ? \t\tand status <> 'done' group by contract_task_id having task_date = min(task_date)";
            BaseStringMap bsm = this.connection.queryBsm(sql, contractTask.getContractTaskId());
            if (bsm != null) {
                contractTask.setNextAlertDate(bsm.getPropertyDate("task_date"));
                contractTask.setNextStatus(bsm.getProperty("status"));
            } else {
                String sql2 = "select max(task_date) from contract__contract_task_event where contract_task_id = ? ";
                Date d = (Date)this.connection.queryValue(sql2, Date.class, contractTask.getContractTaskId());
                contractTask.setNextAlertDate(d);
                if (d == null) {
                    contractTask.setNextStatus("inactive");
                } else {
                    contractTask.setNextStatus("done");
                }
            }
        }
    }

    public List<ContractTask> readTasks(Integer contractId) throws SQLException, JTBException {
        List l = this.queryToList(ContractTask.class, "select * from contract__contract_task where contract_id = ? ", contractId);
        this.setNextValues(l);
        l.sort(new Comparator<ContractTask>(){

            @Override
            public int compare(ContractTask o1, ContractTask o2) {
                long t2;
                if ("done".equals(o1.getNextStatus()) && !"done".equals(o2.getNextStatus())) {
                    return 1;
                }
                if (!"done".equals(o1.getNextStatus()) && "done".equals(o2.getNextStatus())) {
                    return -1;
                }
                if (o1.isActive() && !o2.isActive()) {
                    return -1;
                }
                if (o2.isActive() && !o1.isActive()) {
                    return 1;
                }
                long t1 = o1.getNextAlertDate() == null ? 0L : o1.getNextAlertDate().getTime();
                long l = t2 = o2.getNextAlertDate() == null ? 0L : o2.getNextAlertDate().getTime();
                if (t1 == t2) {
                    return 0;
                }
                return t1 > t2 ? 1 : -1;
            }
        });
        return l;
    }

    public ContractTask readTask(Integer contractTaskId) throws SQLException, JTBException {
        ContractTask ct = (ContractTask)this.queryToObject(ContractTask.class, "select * from contract__contract_task where contract_task_id = ?", contractTaskId);
        List l = this.queryToList(ContractTaskEvent.class, "select * from contract__contract_task_event where contract_task_id = ? order by task_date asc", ct.getContractTaskId());
        ct.setEvents(l);
        return ct;
    }

    public ContractTaskEvent readTaskEvent(Integer contractTaskEventId) throws SQLException, JTBException {
        ContractTaskEvent e = (ContractTaskEvent)this.queryToObject(ContractTaskEvent.class, "select * from contract__contract_task_event where contract_task_event_id = ?", contractTaskEventId);
        return e;
    }

    public ContractTask readTaskContractCustomer(Integer contractTaskId) throws SQLException, JTBException {
        String sql = "select ct.*, customer.customer_name, contract.name contract_name\nfrom contract__contract_task ct\nleft join contract__contract contract on (contract.contract_id = ct.contract_id)\nleft join customer__customer customer on (customer.customer_id = contract.customer_id)\nwhere ct.contract_task_id = ?\n";
        ContractTask ct = (ContractTask)this.queryToObject(ContractTask.class, sql, contractTaskId);
        return ct;
    }

    public Integer saveTask(ContractTask ct, Integer userId) throws IOException, SQLException, JTBException {
        ContractTask oldTask = null;
        if (ct.getContractTaskId() != null) {
            oldTask = this.readTask(ct.getContractTaskId());
        }
        Integer id = this.connection.save("contract__contract_task", "contract_task_id", ct.getBaseStringMap());
        Contract c = this.readContract(ct.getContractId());
        Activity a = new Activity();
        a.setRefObject(Contract.class.getName());
        a.setRefId(c.getContractId());
        a.setSubRefObject(ContractTask.class.getName());
        a.setSubRefId(ct.getContractTaskId());
        if (userId != null) {
            a.setUserId(userId);
        }
        a.setCustomerId(c.getCustomerId());
        if (oldTask != null) {
            a.setCode("task-updated");
            a.setShortDescription("Contract task changed: " + c.getName() + ", " + ct.getDescription());
            a.logChange(oldTask, ct, this.contractTaskLogFields);
        } else {
            a.setCode("task-new");
            a.setShortDescription("Create task: " + c.getName() + ", " + ct.getDescription());
            a.logNew(ct, this.contractTaskLogFields);
        }
        this.saveActivity(a);
        if (oldTask != null && oldTask.getNoticeMoment() != null && !oldTask.getNoticeMoment().equals(ct.getNoticeMoment())) {
            this.connection.query("delete from contract__contract_task where status='open' and ref_contract_task_id = ?", ct.getContractTaskId());
        }
        this.buildTasksEvents(ct);
        return id;
    }

    public void deleteTask(Integer contractTaskId, Integer userId) throws IOException, SQLException, JTBException {
        ContractTask ct = this.readTask(contractTaskId);
        Contract c = this.readContract(ct.getContractId());
        Activity a = new Activity();
        a.setRefObject(Contract.class.getName());
        a.setRefId(c.getContractId());
        a.setSubRefObject(ContractTask.class.getName());
        a.setSubRefId(ct.getContractTaskId());
        if (userId != null) {
            a.setUserId(userId);
        }
        a.setCustomerId(c.getCustomerId());
        a.setCode("task-deleted");
        a.setShortDescription("Contract task deleted: " + c.getName() + ", " + ct.getDescription());
        a.logDelete(ct, this.contractTaskLogFields);
        this.saveActivity(a);
        this.connection.query("delete from contract__contract_task where contract_task_id = ?", contractTaskId);
        this.connection.query("delete from contract__contract_task_event where contract_task_id = ?", contractTaskId);
    }

    public void updateTaskEventStatus(Integer contractTaskEventId, String status, String note) throws SQLException, IOException, JTBException {
        ContractTaskEvent event = this.readTaskEvent(contractTaskEventId);
        Contract contract = this.readContract(event.getContractId());
        if (note == null) {
            note = "";
        }
        note = note.trim();
        Activity a = new Activity();
        if ("open".equals(status) || "inprogress".equals(status) || "done".equals(status)) {
            if (!event.getStatus().equals(status)) {
                a.addValue("status", event.getStatus(), status);
                this.connection.query("update contract__contract_task_event set status = ? where contract_task_event_id = ?", status, contractTaskEventId);
            }
        } else {
            throw new InvalidStateException("Invalid status: " + status);
        }
        if (!note.equals(event.getNote())) {
            a.addValue("note", event.getNote(), note);
            this.connection.query("update contract__contract_task_event set note = ? where contract_task_event_id = ?", note, contractTaskEventId);
        }
        if (a.changeCount() > 0) {
            a.setRefObject(Contract.class.getName());
            a.setRefId(contract.getContractId());
            a.setCustomerId(contract.getCustomerId());
            a.setCode("task-updated");
            a.setShortDescription("Contract #" + String.valueOf(contract.getContractId()) + " task status changed: " + event.getStatus() + " => " + status);
            this.saveActivity(a);
        }
    }

    public List<Contract> readActiveContracts() throws SQLException, JTBException, IOException {
        List<BaseStringMap> recs = this.connection.queryBsmList("select distinct contract_id from contract__contract_task where active = true", new Object[0]);
        ArrayList<Contract> list = new ArrayList<Contract>();
        for (BaseStringMap rec : recs) {
            Integer contractId = rec.getPropertyInt("contract_id");
            Contract c = this.readContract(contractId);
            list.add(c);
        }
        return list;
    }

    public List<Contract> readByCustomer(Integer userId, Integer customerId) throws SQLException {
        List<BaseStringMap> bsms = this.connection.queryBsmList("select * from contract__contract where customer_id = ? order by start_date", customerId);
        ArrayList<Contract> contracts = new ArrayList<Contract>();
        for (BaseStringMap bsm : bsms) {
            Contract c = new Contract();
            c.setBaseStringMap(bsm);
            if (userId == null || !this.hasPermission(userId, c.getContractId())) continue;
            contracts.add(c);
        }
        return contracts;
    }

    public QueryResult<ContractTask> searchTasks(Map<String, Object> opts) throws SQLException, JTBException {
        String contractFilter;
        String sql = "select ct.*, contract.name contract_name, customer.customer_name, contract.customer_id, cte1.task_date alert_date, cte1.status alert_status, cte2.task_date last_alert_date, cte2.status last_alert_status\nfrom contract__contract_task ct\nleft join contract__contract_task_event cte1 on (ct.contract_task_id = cte1.contract_task_id and cte1.status <> 'done')\nleft join contract__contract_task_event cte2 on (ct.contract_task_id = cte2.contract_task_id)\nleft join contract__contract contract on (contract.contract_id = ct.contract_id)\nleft join customer__customer customer on (customer.customer_id = contract.customer_id)\n{{where}}\ngroup by ct.contract_task_id\nhaving\n\t(cte1.task_date = min(cte1.task_date) or cte1.task_date is null)\n\tand (cte2.task_date = max(cte2.task_date) or cte2.task_date is null)\norder by ifnull( cte1.task_date, cte2.task_date) desc\n";
        if (MapUtil.hasProperty(opts, "dashboardRequest") && ((Boolean)opts.get("dashboardRequest")).booleanValue()) {
            opts.put("upcoming", false);
            opts.put("status_open", true);
            opts.put("status_inprogress", true);
            opts.put("status_done", false);
        }
        ArrayList<Object> where = new ArrayList<Object>();
        ArrayList<Object> params = new ArrayList<Object>();
        int statusSelected = 0;
        if (MapUtil.boolValue(opts, "status_open") || MapUtil.boolValue(opts, "status_inprogress") || MapUtil.boolValue(opts, "status_done")) {
            Object wstatus = "";
            if (((Boolean)opts.get("status_open")).booleanValue()) {
                if (((String)wstatus).length() > 0) {
                    wstatus = (String)wstatus + " OR ";
                }
                wstatus = (String)wstatus + " ( ifnull(cte1.status, cte2.status) = 'open' ) ";
                ++statusSelected;
            }
            if (((Boolean)opts.get("status_inprogress")).booleanValue()) {
                if (((String)wstatus).length() > 0) {
                    wstatus = (String)wstatus + " OR ";
                }
                wstatus = (String)wstatus + " ( ifnull(cte1.status, cte2.status) = 'inprogress' ) ";
                ++statusSelected;
            }
            if (((Boolean)opts.get("status_done")).booleanValue()) {
                if (((String)wstatus).length() > 0) {
                    wstatus = (String)wstatus + " OR ";
                }
                wstatus = (String)wstatus + " ( ifnull(cte1.status, cte2.status) = 'done' ) ";
                ++statusSelected;
            }
            where.add(" ct.active = true ");
            if (((String)wstatus).length() > 0) {
                where.add(wstatus);
            }
        }
        if (MapUtil.hasProperty(opts, "q")) {
            String q = "%" + String.valueOf(opts.get("q")) + "%";
            where.add("customer.customer_name LIKE ? OR contract.name LIKE ? OR ct.description LIKE ?");
            params.add(q);
            params.add(q);
            params.add(q);
        }
        Date today = new Date();
        today.setHours(23);
        today.setMinutes(59);
        today.setSeconds(59);
        if (MapUtil.hasProperty(opts, "upcoming") && !((Boolean)opts.get("upcoming")).booleanValue()) {
            if (statusSelected > 0) {
                where.add(" cte1.task_date <= ? or (cte1.task_date is null and cte2.task_date <= ?) ");
                params.add(DateUtil.dateForm2.format(today));
                params.add(DateUtil.dateForm2.format(today));
            } else {
                where.add(" cte1.task_date <= ? or (cte1.task_date is not null and cte1.task_date <= ?) or (cte1.task_date is null and cte2.task_date <= ?) ");
                params.add(DateUtil.dateForm2.format(today));
                params.add(DateUtil.dateForm2.format(today));
                params.add(DateUtil.dateForm2.format(today));
            }
        }
        if (MapUtil.hasProperty(opts, "allowedUserId") && opts.get("allowedUserId") instanceof Integer && (contractFilter = this.filterWhereUser((Integer)opts.get("allowedUserId"))) != null) {
            where.add("ct.contract_id IN " + contractFilter);
        }
        if (where.size() > 0) {
            String sqlWhere = "WHERE (" + StringUtil.join(") AND (", where) + ") ";
            sql = sql.replace("{{where}}", sqlWhere);
        } else {
            sql = sql.replace("{{where}}", "");
        }
        ResultSet rs = this.connection.queryResultSet(sql, params.toArray());
        QueryResult<ContractTask> qr = new QueryResult<ContractTask>();
        qr.fill(ContractTask.class, rs, opts);
        this.setNextValues(qr.getObjects());
        rs.close();
        return qr;
    }

    public void updateContractTasks(Integer contractId) throws SQLException, JTBException, IOException {
        Contract c = this.readContract(contractId);
        for (ContractTask ct : c.getTasks()) {
            this.buildTasksEvents(ct);
        }
    }

    public void cronGenerateRefTasks() throws SQLException, JTBException, IOException {
        List<Contract> activeContracts = this.readActiveContracts();
        for (Contract c : activeContracts) {
            for (ContractTask ct : c.getTasks()) {
                this.buildTasksEvents(ct);
            }
        }
    }

    protected void buildTasksEvents(ContractTask contractTask) throws SQLException, JTBException, IOException {
        if (!contractTask.isActive()) {
            return;
        }
        "on_date".equals(contractTask.getNoticeMoment());
        int ymdNow = DateUtil.ymdNow();
        List<ContractTaskEvent> events = this.getTaskEvents(contractTask.getContractTaskId());
        Contract c = (Contract)this.queryToObject(Contract.class, "select * from contract__contract where contract_id = ?", contractTask.getContractId());
        if (contractTask.getNoticeMoment().equals("since_date_recurrent")) {
            ContractTaskEvent evt = null;
            int loopCount = 0;
            this.createEvent(contractTask, contractTask.getTaskDate());
            do {
                Date d;
                if ((evt = this.createEvent(contractTask, d = this.nextDate(c, contractTask, events))) == null) continue;
                events.add(evt);
            } while (evt != null && loopCount++ < 20);
        } else if (contractTask.getNoticeMoment().equals("on_date")) {
            this.createEvent(contractTask, contractTask.getTaskDate());
        } else {
            Date d = this.nextDate(c, contractTask, events);
            this.createEvent(contractTask, d);
        }
    }

    public ContractTaskEvent createEvent(ContractTask contractTask, Date date) throws SQLException, IOException {
        if (date == null) {
            return null;
        }
        String ymd = DateUtil.dateForm3.format(date);
        Integer c = (Integer)this.connection.queryValue("select count(*) from contract__contract_task_event where contract_task_id = ? and date(task_date) = ?", Integer.class, contractTask.getContractTaskId(), ymd);
        if (c > 0) {
            return null;
        }
        String note = "";
        if (contractTask.getNoticeMoment().equals("on_date")) {
            String sql = "select note from contract__contract_task_event where contract_task_id = ? and status in ('open', 'inprogress') and trim(ifnull(note,'')) <> '' order by task_date desc limit 1 ";
            note = (String)this.connection.queryValue(sql, String.class, contractTask.getContractTaskId());
            if (note == null) {
                note = "";
            }
            this.connection.query("delete from contract__contract_task_event where contract_task_id = ? and status in ('open', 'inprogress')", contractTask.getContractTaskId());
        }
        ContractTaskEvent cte = new ContractTaskEvent();
        cte.setContractTaskId(contractTask.getContractTaskId());
        cte.setContractId(contractTask.getContractId());
        cte.setTaskDate(date);
        cte.setStatus("open");
        cte.setNote(note);
        this.connection.save("contract__contract_task_event", "contract_task_event_id", cte);
        return cte;
    }

    public List<ContractTaskEvent> getTaskEvents(Integer contractTaskId) throws SQLException, JTBException {
        List l = this.queryToList(ContractTaskEvent.class, "select *  from contract__contract_task_event where contract_task_id = ? order by task_date", contractTaskId);
        return l;
    }

    protected Date nextDate(Contract contract, ContractTask mainContractTask, List<ContractTaskEvent> events) throws SQLException, JTBException {
        ContractTaskEvent lastEvent = null;
        if (events.size() > 0) {
            lastEvent = events.get(events.size() - 1);
        }
        if ("on_date".equals(mainContractTask.getNoticeMoment())) {
            throw new InvalidStateException("nextDate() called for on_date-moment");
        }
        if ("since_date_recurrent".equals(mainContractTask.getNoticeMoment())) {
            Date d2;
            int ymdD2;
            Date d1 = mainContractTask.getTaskDate();
            int ymdNow = DateUtil.ymdNow();
            int x = 1;
            while ((ymdD2 = DateUtil.date2ymd(d2 = DateUtil.calcDate(d1, mainContractTask.getTimeNoticeUnit(), mainContractTask.getTimeNotice() * x)).intValue()) < ymdNow && lastEvent != null && !d2.after(lastEvent.getTaskDate())) {
                ++x;
            }
            return d2;
        }
        if ("after_start".equals(mainContractTask.getNoticeMoment())) {
            if (contract.getStartDate() == null) {
                return null;
            }
            return this.calculateMoment(mainContractTask, contract.getStartDate());
        }
        if ("before_start".equals(mainContractTask.getNoticeMoment())) {
            if (contract.getStartDate() == null) {
                return null;
            }
            return this.calculateMoment(mainContractTask, contract.getStartDate());
        }
        if ("after_renewal".equals(mainContractTask.getNoticeMoment())) {
            if (contract.getRenewalDate() == null) {
                return null;
            }
            return this.calculateMoment(mainContractTask, contract.getRenewalDate());
        }
        if ("before_renewal".equals(mainContractTask.getNoticeMoment())) {
            if (contract.getRenewalDate() == null) {
                return null;
            }
            return this.calculateMoment(mainContractTask, contract.getRenewalDate());
        }
        if ("before_end".equals(mainContractTask.getNoticeMoment())) {
            if (contract.getEndDate() == null) {
                return null;
            }
            return this.calculateMoment(mainContractTask, contract.getEndDate());
        }
        if ("after_end".equals(mainContractTask.getNoticeMoment())) {
            if (contract.getEndDate() == null) {
                return null;
            }
            return this.calculateMoment(mainContractTask, contract.getEndDate());
        }
        return null;
    }

    protected Date calculateMoment(ContractTask ct, Date refDate) {
        int x = 1;
        if (ct.getNoticeMoment().startsWith("before_")) {
            x = -1;
        }
        if ("day".equals(ct.getTimeNoticeUnit())) {
            return DateUtil.nextDay(refDate, ct.getTimeNotice() * x);
        }
        if ("week".equals(ct.getTimeNoticeUnit())) {
            return DateUtil.nextWeek(refDate, ct.getTimeNotice() * x);
        }
        if ("month".equals(ct.getTimeNoticeUnit())) {
            return DateUtil.nextMonth(refDate, ct.getTimeNotice() * x);
        }
        if ("year".equals(ct.getTimeNoticeUnit())) {
            return DateUtil.nextMonth(refDate, ct.getTimeNotice() * 12 * x);
        }
        return null;
    }

    public Contract readContract(Integer contractId) throws SQLException, JTBException {
        Contract c = (Contract)this.queryToObject(Contract.class, "select * from contract__contract where contract_id = ?", contractId);
        if (c == null) {
            return null;
        }
        if (c.getCustomerId() != null) {
            Customer cust = this.customerService.readCustomer(c.getCustomerId());
            c.setCustomer(cust);
        }
        List<ContractTask> tasks = this.readTasks(contractId);
        for (ContractTask ct : tasks) {
            ct.createWarningMessage(c);
        }
        c.setTasks(tasks);
        List<DbFile> files = this.listFiles(contractId);
        c.setFiles(files);
        List<Contract> related = this.listRelated(contractId);
        c.setRelatedContracts(related);
        List<UserPermission> perms = this.listPermissions(contractId);
        c.setPermissions(perms);
        return c;
    }

    public Integer saveContract(Contract c, Integer loggedIn_userId) throws IOException, SQLException, JTBException {
        Contract oldContract = null;
        if (c.getContractId() != null) {
            oldContract = this.readContract(c.getContractId());
        }
        Integer id = this.connection.save("contract__contract", "contract_id", c);
        ArrayList<Integer> userPermissionIds = new ArrayList<Integer>();
        int x = 0;
        while (x < c.getPermissions().size()) {
            UserPermission cp = c.getPermissions().get(x);
            cp.setRefObject("contract");
            cp.setRefId(id);
            Integer cpid = this.connection.save("base__user_permission", "user_permission_id", cp);
            userPermissionIds.add(cpid);
            ++x;
        }
        if (userPermissionIds.size() == 0) {
            this.connection.query("delete from base__user_permission where ref_object='contract' and ref_id = ?", id);
        } else {
            String str = StringUtil.join(", ", userPermissionIds);
            this.connection.query("delete from base__user_permission where ref_object='contract' and ref_id = ? AND user_permission_id NOT IN (" + str + ")", id);
        }
        Activity a = new Activity();
        a.setRefObject(Contract.class.getName());
        a.setRefId(c.getContractId());
        a.setUserId(loggedIn_userId);
        a.setCustomerId(c.getCustomerId());
        if (oldContract != null) {
            a.setCode("contract-updated");
            if (c.getBaseStringMap().hasProperty("activityLogDescription")) {
                a.setShortDescription(c.getBaseStringMap().getProperty("activityLogDescription"));
            } else {
                a.setShortDescription("Contract changed: " + c.getName());
            }
            a.logChange(oldContract, c, this.contractLogFields);
        } else {
            a.setCode("contract-new");
            a.setShortDescription("Create contract: " + c.getName());
            a.logNew(c, this.contractLogFields);
        }
        this.saveActivity(a);
        this.updateContractTasks(id);
        return id;
    }

    public void deleteContract(Integer contractId, Integer loggedIn_userId) throws SQLException, JTBException, IOException {
        Contract c = this.readContract(contractId);
        this.connection.query("delete from contract__contract_task where contract_id = ?", contractId);
        this.connection.query("delete from contract__contract_file where contract_id = ?", contractId);
        this.connection.query("delete from contract__contract_related where contract_id = ?", contractId);
        this.connection.query("delete from contract__contract where contract_id = ?", contractId);
        Activity a = new Activity();
        a.setRefObject(Contract.class.getName());
        a.setRefId(c.getContractId());
        a.setUserId(loggedIn_userId);
        a.setCustomerId(c.getCustomerId());
        a.setCode("contract-delete");
        a.setShortDescription("Delete contract: " + c.getName());
        a.logDelete(c, this.contractLogFields);
        this.saveActivity(a);
    }

    public void renewContract(Contract c) throws IOException, SQLException, JTBException {
        if (c.getEndDate() == null) {
            System.out.println("Contract.renewContract(" + String.valueOf(c.getContractId()) + "), skipping, no end date");
            return;
        }
        if (!c.isAutoRenew()) {
            System.out.println("Contract.renewContract(" + String.valueOf(c.getContractId()) + "), no autorenew");
            return;
        }
        if (!"active".equals(c.getStatus())) {
            System.out.println("Contract.renewContract(" + String.valueOf(c.getContractId()) + "), skipping, status not active");
            return;
        }
        Date originalEndDate = c.getEndDate();
        int ymdRenewalDate = DateUtil.date2ymd(c.getRenewalDate());
        int ymdToday = DateUtil.date2ymd(new Date());
        boolean updated = false;
        while (ymdRenewalDate <= ymdToday) {
            Date d = c.getEndDate();
            d = DateUtil.calcDate(d, c.getRenewUnit(), c.getRenewPeriod());
            c.setEndDate(d);
            int prevRenewalDate = ymdRenewalDate;
            ymdRenewalDate = DateUtil.date2ymd(c.getRenewalDate());
            updated = true;
            if (ymdRenewalDate > prevRenewalDate) continue;
            c.setEndDate(originalEndDate);
            updated = false;
            break;
        }
        if (updated) {
            Date newEndDate = c.getEndDate();
            c = this.readContract(c.getContractId());
            c.setEndDate(newEndDate);
            c.getBaseStringMap().setProperty("activityLogDescription", "Contract renewed: " + c.getName() + ", " + DateUtil.dateForm4.format(originalEndDate) + " => " + DateUtil.dateForm4.format(c.getEndDate()));
            this.saveContract(c, null);
            c.getBaseStringMap().unsetProperty("activityLogDescription");
            this.updateContractTasks(c.getContractId());
        }
    }

    public void linkContract(Integer contractId, Integer refContractId, Integer reqUserId) throws SQLException, IOException, JTBException {
        Integer i = (Integer)this.connection.queryValue("select count(*) from contract__contract_related where contract_id = ? and ref_contract_id = ?", Integer.class, contractId, refContractId);
        if (i > 0) {
            return;
        }
        Integer s = (Integer)this.connection.queryValue("select max(sort) from contract__contract_related where contract_id = ?", Integer.class, contractId);
        s = s == 0 ? Integer.valueOf(1) : Integer.valueOf(s + 1);
        ContractRelated cr = new ContractRelated();
        cr.setContractId(contractId);
        cr.setRefContractId(refContractId);
        cr.setSort(s);
        this.connection.save("contract__contract_related", "contract_related_id", cr);
        Contract contract = this.readContract(contractId);
        Contract refContract = this.readContract(refContractId);
        Activity a = new Activity();
        a.setUserId(reqUserId);
        a.setRefObject(Contract.class.getName());
        a.setRefId(contractId);
        a.setCustomerId(contract.getCustomerId());
        a.setCode("contract-linked");
        a.setShortDescription("Contract, linked: " + contract.getName() + " <=> " + refContract.getName());
        a.addValue("contractId", null, contract.getContractId());
        a.addValue("refContractId", null, refContract.getContractId());
        this.saveActivity(a);
    }

    public void unlinkContract(Integer contractId, Integer refContractId, Integer reqUserId) throws SQLException, IOException, JTBException {
        this.connection.query("delete from contract__contract_related where contract_id = ? and ref_contract_id = ?", contractId, refContractId);
        Contract contract = this.readContract(contractId);
        Contract refContract = this.readContract(refContractId);
        Activity a = new Activity();
        a.setUserId(reqUserId);
        a.setRefObject(Contract.class.getName());
        a.setRefId(contractId);
        a.setCustomerId(contract.getCustomerId());
        a.setCode("contract-unlinked");
        a.setShortDescription("Contract, unlinked: " + contract.getName() + " <=> " + refContract.getName());
        a.addValue("contractId", null, contract.getContractId());
        a.addValue("refContractId", null, refContract.getContractId());
        this.saveActivity(a);
    }

    public List<Integer> linkedContractIds(Integer contractId) throws SQLException {
        ArrayList<Integer> l = new ArrayList<Integer>();
        ResultSet rs = this.connection.queryResultSet("select distinct ref_contract_id from contract__contract_related where contract_id = ?", contractId);
        while (rs.next()) {
            Integer id = rs.getInt("ref_contract_id");
            l.add(id);
        }
        return l;
    }

    public List<Contract> listRelated(Integer contractId) throws SQLException, JTBException {
        String sql = "select c.*, ct.name contract_type_name, customer.customer_name\nfrom contract__contract c\njoin contract__contract_related cr on (c.contract_id = cr.ref_contract_id)\nleft join contract__contract_type ct on (c.contract_type_id = ct.contract_type_id)\nleft join customer__customer customer on (customer.customer_id = c.customer_id)\nwhere cr.contract_id = ?\norder by cr.sort\n";
        List contracts = this.queryToList(Contract.class, sql, contractId);
        return contracts;
    }

    public List<DbFile> listFiles(Integer contractId) throws SQLException, JTBException {
        String sql = "\t\tselect df.*\nfrom base__db_file df\njoin contract__contract_file cf on (df.db_file_id = cf.db_file_id)\nwhere cf.contract_id=?\norder by cf.sort\n";
        List files = this.queryToList(DbFile.class, sql, contractId);
        return files;
    }

    public void updateFileSort(Integer contractId, List<Integer> dbFileIds) throws SQLException {
        int x = 0;
        while (x < dbFileIds.size()) {
            Integer fid = dbFileIds.get(x);
            this.connection.query("update contract__contract_file set sort = ? where contract_id = ? and db_file_id = ?", x, contractId, fid);
            ++x;
        }
    }

    public void linkFile(Integer contractId, Integer dbFileId, Integer reqUserId) throws SQLException, IOException, JTBException {
        Integer count = (Integer)this.connection.queryValue("select count(*) from contract__contract_file where contract_id = ? and db_file_id = ?", Integer.class, contractId, dbFileId);
        if (count > 0) {
            return;
        }
        Integer sort = (Integer)this.connection.queryValue("select max(sort) from contract__contract_file where contract_id = ?", Integer.class, contractId);
        if (sort == null) {
            sort = 0;
        }
        sort = sort + 1;
        this.connection.query("insert into contract__contract_file (contract_id, db_file_id, sort) values (?, ?, ?)", contractId, dbFileId, sort);
        DbFile df = this.fileService.readFile(dbFileId);
        Contract c = this.readContract(contractId);
        Activity a = new Activity();
        a.setRefObject(Contract.class.getName());
        a.setRefId(contractId);
        a.setUserId(reqUserId);
        a.setCustomerId(c.getCustomerId());
        a.setCode("document-linked");
        a.setShortDescription("Contract, document linked: " + c.getName() + ", " + df.getOriginalFilename());
        a.addValue("dbFileId", null, df.getDbFileId());
        a.addValue("originalFilename", null, df.getOriginalFilename());
        a.addValue("refDescription", null, df.getRefDescription());
        this.saveActivity(a);
    }

    public void unlinkFile(Integer contractId, Integer dbFileId, Integer reqUserId) throws SQLException, JTBException, IOException {
        this.connection.query("delete from contract__contract_file where contract_id = ? and db_file_id = ?", contractId, dbFileId);
        DbFile df = this.fileService.readFile(dbFileId);
        Contract c = this.readContract(contractId);
        Activity a = new Activity();
        a.setRefObject(Contract.class.getName());
        a.setRefId(contractId);
        a.setCustomerId(c.getCustomerId());
        a.setUserId(reqUserId);
        a.setCode("document-linked");
        a.setShortDescription("Contract, document unlinked: " + c.getName() + ", " + df.getOriginalFilename());
        a.addValue("dbFileId", null, df.getDbFileId());
        a.addValue("originalFilename", null, df.getOriginalFilename());
        a.addValue("refDescription", null, df.getRefDescription());
        this.saveActivity(a);
    }

    public List<UserPermission> listPermissions(Integer contractId) throws SQLException, JTBException {
        String sql = "select p.*, u.username, ug.group_name\nfrom base__user_permission p\nleft join base__user u on (p.user_id = u.user_id)\nleft join base__user_group ug on (p.group_id = ug.user_group_id)\nwhere p.ref_object = 'contract' and p.ref_id = ?\n";
        List cps = this.queryToList(UserPermission.class, sql, contractId);
        return cps;
    }

    public boolean hasPermission(Integer userId, Integer contractId) throws SQLException {
        if (this.userService.isAdmin(userId)) {
            return true;
        }
        String sql = "select count(*) from base__user_permission p left join base__user_group_link ugl on (p.group_id = ugl.user_group_id) where ref_object = 'contract' and ref_id = ? \t\tAND (p.user_id = ? or ugl.user_id = ?) limit  1 ";
        Integer c = this.connection.queryInteger(sql, contractId, userId, userId);
        return c > 0;
    }

    public boolean hasWritePermission(Integer userId, Integer contractId) throws SQLException {
        if (this.userService.isAdmin(userId)) {
            return true;
        }
        String sql = "select count(*) from base__user_permission p left join base__user_group_link ugl on (p.group_id = ugl.user_group_id) where ref_object = 'contract' and ref_id = ? and access_method='write' \t\tAND (p.user_id = ? or ugl.user_id = ?) limit  1 ";
        Integer c = this.connection.queryInteger(sql, contractId, userId, userId);
        return c > 0;
    }

    public boolean dailyAlertSent(Integer contractTaskId, Integer userId) throws SQLException {
        String sql = "select daily_alert_sent from contract__contract_task_user_meta where contract_task_id = ? and user_id = ?";
        Date d = (Date)this.queryValue(Date.class, sql, contractTaskId, userId);
        return d != null;
    }

    public void setDailyAlerts(Integer userId, boolean b, Integer reqUserId) throws SQLException, IOException {
        if (this.hasDailyAlerts(userId) == b) {
            return;
        }
        this.metaService.setMeta("user", userId, "contract_daily_alerts", b ? "1" : "0");
        Activity a = new Activity();
        a.setRefObject(User.class.getName());
        a.setRefId(userId);
        a.setUserId(reqUserId);
        a.setCode("daily-alerts");
        if (b) {
            a.setShortDescription("Daily alerts activated");
        } else {
            a.setShortDescription("Daily alerts disabled");
        }
        this.saveActivity(a);
    }

    public boolean hasDailyAlerts(Integer userId) throws SQLException {
        String r = this.metaService.getMetaByKey("user", userId, "contract_daily_alerts", "1");
        return "1".equals(r);
    }

    public void setWeeklyUpdate(Integer userId, Boolean b, Integer reqUserId) throws SQLException, IOException {
        if (this.hasWeeklyUpdate(userId) == b.booleanValue()) {
            return;
        }
        this.metaService.setMeta("user", userId, "contract_weekly_update", b != false ? "1" : "0");
        Activity a = new Activity();
        a.setRefObject(User.class.getName());
        a.setRefId(userId);
        a.setUserId(reqUserId);
        a.setCode("weekly-update");
        if (b.booleanValue()) {
            a.setShortDescription("Weekly update activated");
        } else {
            a.setShortDescription("Weekly update disabled");
        }
        this.saveActivity(a);
    }

    public boolean hasWeeklyUpdate(Integer userId) throws SQLException {
        String r = this.metaService.getMetaByKey("user", userId, "contract_weekly_update", "1");
        return "1".equals(r);
    }

    public ContractTaskUserMeta readTaskUserMeta(Integer contractTaskId, Integer userId) throws SQLException, JTBException {
        ContractTaskUserMeta m = (ContractTaskUserMeta)this.queryToObject(ContractTaskUserMeta.class, "select * from contract__contract_task_user_meta where contract_task_id = ? and user_id = ?", contractTaskId, userId);
        return m;
    }

    public void markDailyAlertSent(Integer contractTaskId, Integer userId) throws IOException, SQLException, JTBException {
        ContractTaskUserMeta m = this.readTaskUserMeta(contractTaskId, userId);
        if (m == null) {
            m = new ContractTaskUserMeta();
            m.setContractTaskId(contractTaskId);
            m.setUserId(userId);
        }
        m.setDailyAlertSent(new Date());
        this.connection.save("contract__contract_task_user_meta", "contract_task_user_meta_id", m);
    }
}

